#include "ResourceCompilerLink.h"

#include "windows.h"
#include <ResourceCompilerHelper.h>


#define MODULE_NAME "CryTIFPlugin"

bool InvokeResourceCompiler( const char *szFileName, const char *szAdditionalSettings )
{
	CResourceCompilerHelper rch(MODULE_NAME);

	// make command for execution
	char szRemoteCmdLine[512];

	if(!szAdditionalSettings)
		szAdditionalSettings="";				// better than using default values - the compiler might mess that up

	bool bShowWindow=false, bHideCustom=false;

	// extract path of dll, and read path of ResourceCompiler from file CryExport.ini.
	
	const char *szRootRCPath = rch.GetRootPath();

	char szRemoteDirectory[512];
	// we use /nooutput because the file name from Photoshop is temporary and not the one we want to use
	sprintf(szRemoteDirectory, "%s/Bin32/rc",szRootRCPath);

	const char *szHideCustom = bHideCustom ? " /userdialogcustom=0" : "";

	// we use /nooutput because the file name from Photoshop is temporary and not the one we want to use
	//	sprintf(szRemoteCmdLine, "%s/rc.exe \"%s\" /userdialog=1 %s /nooutput%s",szRemoteDirectory,szFileName,szAdditionalSettings,szHideCustom);
	sprintf(szRemoteCmdLine, "%s/rc.exe \"%s\" /userdialog=1 %s%s",szRemoteDirectory,szFileName,szAdditionalSettings,szHideCustom);

	STARTUPINFO si;
	ZeroMemory( &si, sizeof(si) );
	si.cb = sizeof(si);
	si.dwX = 100;
	si.dwY = 100;
	si.dwFlags = STARTF_USEPOSITION;

	PROCESS_INFORMATION pi;
	ZeroMemory( &pi, sizeof(pi) );

	if( !CreateProcess( NULL, // No module name (use command line). 
		szRemoteCmdLine,				// Command line. 
		NULL,									  // Process handle not inheritable. 
		NULL,									  // Thread handle not inheritable. 
		FALSE,								  // Set handle inheritance to FALSE. 
		bShowWindow?0:CREATE_NO_WINDOW,	// creation flags. 
		NULL,									  // Use parent's environment block. 
		szRemoteDirectory,			// Set starting directory. 
		&si,										// Pointer to STARTUPINFO structure.
		&pi ))									  // Pointer to PROCESS_INFORMATION structure.
	{
		MessageBox(0,szRemoteCmdLine,szRemoteDirectory,MB_ICONERROR|MB_OK);
		MessageBox(0,"ResourceCompiler not found\n\nCheck the path and try again!","Error",MB_ICONERROR|MB_OK);
		return false;
	}

	// Wait until child process exits.
	WaitForSingleObject( pi.hProcess, INFINITE );

	// Close process and thread handles. 
	CloseHandle( pi.hProcess );
	CloseHandle( pi.hThread );
	return true;
}


void CallResourceCompilerUI(HWND hParent)
{
	CResourceCompilerHelper rch(MODULE_NAME);
	rch.ResourceCompilerUI(hParent);
}
